# Camera Research - Scanner V2

## Hardware

- **Camera Model**: OV5647 (Raspberry Pi Camera Module v1)
- **Connection**: Ribbon cable via CSI port
- **Platform**: Raspberry Pi Zero 2W
- **Library**: picamera2 (libcamera Python bindings)

## Supported Resolutions

- 640×480 @ 58.92 fps (max)
- 1296×972 @ 46.34 fps (max)
- 1920×1080 @ 32.81 fps (max)
- 2592×1944 @ 15.63 fps (max)

## Configuration Modes: Still vs Video

### Still Mode (`create_still_configuration`)
- Optimized for single high-quality captures
- Uses BGR888 color space with sRGB color profile
- Slower but potentially higher quality

### Video Mode (`create_video_configuration`)
- Optimized for continuous frame capture
- Uses XBGR8888 color space with Rec709 color profile
- **Significantly faster** for burst capture

## Performance Testing

### Test 1: Still Configuration Mode

Captured frames continuously for 5 seconds using `create_still_configuration`:

| Resolution | FPS | Avg Time | Min Time | Max Time |
|-----------|-----|----------|----------|----------|
| 640×480 | 7.89 | 126.8ms | 124.2ms | 163.8ms |
| 1296×972 | 7.22 | 138.5ms | 125.9ms | 334.1ms |
| 1920×1080 | 7.24 | 138.1ms | 122.7ms | 314.0ms |
| 2592×1944 | 4.68 | 213.8ms | 175.8ms | 544.8ms |

### Test 2: Video Configuration Mode

Captured frames continuously for 5 seconds using `create_video_configuration`:

| Resolution | FPS | Avg Time | Min Time | Max Time |
|-----------|-----|----------|----------|----------|
| 640×480 | **32.04** | **31.2ms** | 6.8ms | 34.1ms |
| 1296×972 | **30.29** | **33.0ms** | 20.7ms | 37.2ms |
| 1920×1080 | **30.13** | **33.2ms** | 14.1ms | 46.5ms |
| 2592×1944 | **15.36** | **65.0ms** | 30.5ms | 106.5ms |

### Speed Improvement

| Resolution | Speedup Factor |
|-----------|----------------|
| 640×480 | **4.1×** |
| 1296×972 | **4.2×** |
| 1920×1080 | **4.2×** |
| 2592×1944 | **3.3×** |

## Quality Comparison

Captured comparison images at 1920×1080:
- `capture_still_mode.jpg` - 632KB
- `capture_video_mode.jpg` - 670KB

**Result**: Both images look essentially identical. No visible quality degradation in video mode.

## Recommendations

### For Scanner V2 Implementation

1. **Use Video Configuration** - Provides 3-4× faster capture with no quality loss
2. **Recommended Resolution**: 1920×1080 or 1296×972
   - 30 FPS sustained capture rate
   - ~33ms per frame
   - Sufficient quality for card scanning
3. **Motion Detection**: At 30 FPS, can capture:
   - 15 frames in 0.5 seconds
   - 30 frames in 1 second
   - More than enough for motion-stopped detection

### Code Pattern

```python
from picamera2 import Picamera2

camera = Picamera2()
config = camera.create_video_configuration(main={"size": (1920, 1080)})
camera.configure(config)
camera.start()

# Fast continuous capture
for i in range(30):
    array = camera.capture_array()  # ~33ms per capture
    # Process frame...

camera.stop()
camera.close()
```

### Notes

- Video mode returns RGBA arrays (need conversion to RGB for JPEG)
- Max times show occasional spikes (likely auto-exposure adjustments)
- Full resolution (2592×1944) still achieves 15 FPS in video mode
