#!/bin/bash

SCANNER_IP=${1:-192.168.10.151}
SCANNER_USER=academo
TARGET_DIR=/home/$SCANNER_USER/scanner-v2-python
SERVICE_NAME=scanner.service

echo "Installing scanner to $SCANNER_USER@$SCANNER_IP:$TARGET_DIR"

# Sync code to remote (including requirements.txt)
echo "Syncing code..."
rsync -avz --exclude '.git' --exclude '.claude' --exclude '.vim' --exclude 'logs' --exclude '__pycache__' --exclude '*.pyc' --exclude 'test.jpg' ./ $SCANNER_USER@$SCANNER_IP:$TARGET_DIR/

# Install system dependencies and Python packages
echo "Installing dependencies..."
ssh $SCANNER_USER@$SCANNER_IP "sudo apt-get update && \
    sudo apt-get install -y python3-pip i2c-tools && \
    pip3 install --break-system-packages -r $TARGET_DIR/requirements.txt"

# Copy service file
echo "Installing systemd service..."
scp $SERVICE_NAME $SCANNER_USER@$SCANNER_IP:/tmp/$SERVICE_NAME

# Install and enable service on remote
ssh $SCANNER_USER@$SCANNER_IP "sudo mv /tmp/$SERVICE_NAME /etc/systemd/system/$SERVICE_NAME && \
    sudo systemctl daemon-reload && \
    sudo systemctl enable $SERVICE_NAME && \
    sudo systemctl restart $SERVICE_NAME"

echo "Installation complete!"
echo "Check status with: ssh $SCANNER_USER@$SCANNER_IP 'sudo systemctl status $SERVICE_NAME'"
