from picamera2 import Picamera2
from lib.config import load_config, get_resolution_from_config


class Camera:
    def __init__(self, config=None):
        self.config = config or load_config()
        self.camera = Picamera2()
        self._configure_camera()

    def _configure_camera(self):
        resolution = get_resolution_from_config(self.config)
        camera_config = self.camera.create_still_configuration(main={"size": resolution})
        self.camera.configure(camera_config)
        self.camera.start()
        print(f"Camera ready at {resolution[0]}×{resolution[1]}")

    def reconfigure_resolution(self, new_config=None):
        if new_config:
            self.config = new_config
        else:
            self.config = load_config()

        new_resolution = get_resolution_from_config(self.config)
        print(f"Reconfiguring camera to {new_resolution[0]}×{new_resolution[1]}...")
        self.camera.stop()
        self._configure_camera()

    def capture_array(self):
        return self.camera.capture_array()

    def get_picamera2(self):
        return self.camera

    def stop(self):
        self.camera.stop()

    def close(self):
        self.camera.close()

    def cleanup(self):
        self.stop()
        self.close()
