import json
import os

CONFIG_FILE = "config.json"

RESOLUTION_PRESETS = {
    "maximum": (2592, 1944),
    "high": (1920, 1440),
    "medium": (1296, 972),
    "low": (640, 480),
}


def get_resolution_from_config(config):
    preset = config.get("camera_resolution", "maximum")
    return RESOLUTION_PRESETS.get(preset, RESOLUTION_PRESETS["maximum"])


def load_config():
    if os.path.exists(CONFIG_FILE):
        with open(CONFIG_FILE, "r") as f:
            config = json.load(f)
            if "camera_rotation" not in config:
                config["camera_rotation"] = 180
            if "camera_resolution" not in config:
                config["camera_resolution"] = "maximum"
            return config
    return {
        "server_url": "",
        "access_token": "",
        "camera_rotation": 180,
        "camera_resolution": "maximum",
    }


def save_config(
    server_url, access_token=None, camera_rotation=None, camera_resolution=None
):
    config = load_config()
    config["server_url"] = server_url
    if (
        access_token is not None
        and access_token.strip() != ""
        and access_token != "[TOKEN SET]"
    ):
        config["access_token"] = access_token
    if camera_rotation is not None:
        config["camera_rotation"] = int(camera_rotation)
    if camera_resolution is not None and camera_resolution in RESOLUTION_PRESETS:
        config["camera_resolution"] = camera_resolution
    with open(CONFIG_FILE, "w") as f:
        json.dump(config, f)
