#!/usr/bin/env python3

from picamera2 import Picamera2
import time

def test_capture_speed(duration=5, resolution=(640, 480)):
    print(f"Testing capture speed at {resolution[0]}x{resolution[1]} for {duration} seconds...")

    camera = Picamera2()
    config = camera.create_still_configuration(main={"size": resolution})
    camera.configure(config)
    camera.start()

    print("Camera warmed up, starting capture test...")
    time.sleep(1)

    frame_count = 0
    start_time = time.time()
    capture_times = []

    while time.time() - start_time < duration:
        capture_start = time.time()
        camera.capture_array()
        capture_end = time.time()

        capture_time = capture_end - capture_start
        capture_times.append(capture_time)
        frame_count += 1

        if frame_count % 10 == 0:
            print(f"Captured {frame_count} frames...")

    total_time = time.time() - start_time

    camera.stop()
    camera.close()

    avg_capture_time = sum(capture_times) / len(capture_times)
    fps = frame_count / total_time

    print("\n=== Results ===")
    print(f"Resolution: {resolution[0]}x{resolution[1]}")
    print(f"Total frames: {frame_count}")
    print(f"Total time: {total_time:.2f}s")
    print(f"Average capture time: {avg_capture_time*1000:.1f}ms")
    print(f"FPS: {fps:.2f}")
    print(f"Min capture time: {min(capture_times)*1000:.1f}ms")
    print(f"Max capture time: {max(capture_times)*1000:.1f}ms")
    print()

if __name__ == "__main__":
    test_capture_speed(duration=5, resolution=(640, 480))
    test_capture_speed(duration=5, resolution=(1296, 972))
    test_capture_speed(duration=5, resolution=(1920, 1080))
    test_capture_speed(duration=5, resolution=(2592, 1944))
