#!/usr/bin/env python3

from picamera2 import Picamera2
from PIL import Image
import time

def capture_still_mode(resolution=(1920, 1080)):
    print(f"Capturing in STILL mode at {resolution[0]}x{resolution[1]}...")

    camera = Picamera2()
    config = camera.create_still_configuration(main={"size": resolution})
    camera.configure(config)
    camera.start()

    time.sleep(2)

    array = camera.capture_array()
    image = Image.fromarray(array)
    image.save("capture_still_mode.jpg", quality=95)

    camera.stop()
    camera.close()

    print("Saved capture_still_mode.jpg")

def capture_video_mode(resolution=(1920, 1080)):
    print(f"Capturing in VIDEO mode at {resolution[0]}x{resolution[1]}...")

    camera = Picamera2()
    config = camera.create_video_configuration(main={"size": resolution})
    camera.configure(config)
    camera.start()

    time.sleep(2)

    array = camera.capture_array()
    image = Image.fromarray(array)
    if image.mode == 'RGBA':
        image = image.convert('RGB')
    image.save("capture_video_mode.jpg", quality=95)

    camera.stop()
    camera.close()

    print("Saved capture_video_mode.jpg")

if __name__ == "__main__":
    resolution = (1920, 1080)
    capture_still_mode(resolution)
    time.sleep(1)
    capture_video_mode(resolution)
    print("\nDone! Compare capture_still_mode.jpg vs capture_video_mode.jpg")
