#!/bin/bash

SCANNER_IP=${1:-192.168.10.151}
SCANNER_USER=academo
TARGET_DIR=/home/$SCANNER_USER/scanner-v2-python
SERVICE_NAME=scanner.service

rsync -avz --exclude '.git' --exclude '.claude' --exclude '.vim' --exclude 'logs' --exclude '__pycache__' --exclude '*.pyc' --exclude 'test.jpg' --include='*/' --include='*.py' --include='*.html' --exclude='*' ./ $SCANNER_USER@$SCANNER_IP:$TARGET_DIR/
if [ $? -eq 0 ]; then
    echo "Sync complete, restarting service..."
    ssh $SCANNER_USER@$SCANNER_IP "sudo systemctl restart $SERVICE_NAME"
    echo "Service restarted"
else
    echo "Sync failed"
fi
