import RPi.GPIO as GPIO
import asyncio

# Positive pin to (GPIO26, pin 37)
# Negative pin to any Ground pin (GND)


class Buzzer:
    def __init__(self, pin=26):
        self.pin = pin
        GPIO.setwarnings(False)  # Added to suppress warning
        GPIO.setmode(GPIO.BCM)
        GPIO.setup(self.pin, GPIO.OUT)
        self.pwm = GPIO.PWM(self.pin, 440)

    def cleanup(self):  # Fixed method name
        self.pwm.stop()
        GPIO.cleanup()

    async def ready(self, repeats=1):  # Ascending pattern
        self.pwm.start(50)
        for _ in range(repeats):
            for freq in [392, 440, 494, 523]:  # G4,A4,B4,C5
                self.pwm.ChangeFrequency(freq)
                await asyncio.sleep(0.15)
        self.pwm.stop()

    async def error(self, repeats=2):  # "Loading" pattern
        self.pwm.start(50)
        for _ in range(repeats):
            self.pwm.ChangeFrequency(440)  # A4
            await asyncio.sleep(0.15)
            self.pwm.ChangeFrequency(494)  # B4
            await asyncio.sleep(0.05)
            self.pwm.ChangeFrequency(440)  # A4
            await asyncio.sleep(0.2)
        self.pwm.stop()

    async def wait(self, repeats=1):  # "Processing" pattern
        self.pwm.start(50)
        for _ in range(repeats):
            for freq in [523, 494, 440, 494]:  # C5,B4,A4,B4
                self.pwm.ChangeFrequency(freq)
                await asyncio.sleep(0.2)
        self.pwm.stop()

    async def friendly_beep(self):
        self.pwm.start(50)
        self.pwm.ChangeFrequency(587)  # D5
        await asyncio.sleep(0.06)
        self.pwm.ChangeFrequency(740)  # F#5
        await asyncio.sleep(0.06)
        self.pwm.stop()

    async def quick_beep(self):
        self.pwm.start(50)
        self.pwm.ChangeFrequency(65.41)  # C2 - lower neutral frequency
        await asyncio.sleep(0.01)
        self.pwm.stop()


async def main():
    buzzer = Buzzer(26)
    try:
        await buzzer.friendly_beep()
    finally:
        buzzer.cleanup()


# Test
if __name__ == "__main__":
    asyncio.run(main())
