import RPi.GPIO as GPIO
import signal
import sys

SENSOR_PIN = 17


def on_detect(channel):
    if GPIO.input(channel):
        print("No obstacle detected")
    else:
        print("Obstacle detected")


def cleanup(signum, frame):
    GPIO.cleanup()
    sys.exit(0)


GPIO.setmode(GPIO.BCM)
GPIO.setup(SENSOR_PIN, GPIO.IN)
GPIO.add_event_detect(SENSOR_PIN, GPIO.BOTH,
                      callback=on_detect, bouncetime=20)  # 20ms bounce time

signal.signal(signal.SIGINT, cleanup)
signal.pause()  # Keep program running
