import board
import time
import busio
import adafruit_ssd1306
from PIL import Image, ImageDraw, ImageFont


class AutoSizeOLED:
    def __init__(self, i2c_addr=0x3C, max_lines=3):
        i2c = busio.I2C(board.SCL, board.SDA)
        self.display = adafruit_ssd1306.SSD1306_I2C(
            128, 64, i2c, addr=i2c_addr)
        self.font_path = "/usr/share/fonts/truetype/dejavu/DejaVuSans.ttf"
        self.max_lines = max_lines

    def show_text(self, text):
        image = Image.new("1", (self.display.width, self.display.height))
        draw = ImageDraw.Draw(image)

        for size in range(40, 8, -2):
            font = ImageFont.truetype(self.font_path, size)

            # Try wrapping at this font size
            wrapped = []
            words = text.split()
            current_line = words[0]

            for word in words[1:]:
                # Try adding the next word
                test_line = current_line + " " + word
                bbox = draw.textbbox((0, 0), test_line, font=font)
                width = bbox[2] - bbox[0]

                if width <= self.display.width:
                    current_line = test_line
                else:
                    wrapped.append(current_line)
                    current_line = word

            wrapped.append(current_line)

            if len(wrapped) > self.max_lines:
                continue

            # Calculate if it fits vertically
            line_height = font.getsize("hg")[1]
            total_height = line_height * len(wrapped)

            if total_height <= self.display.height:
                y = (self.display.height - total_height) // 2
                for line in wrapped:
                    bbox = draw.textbbox((0, 0), line, font=font)
                    text_width = bbox[2] - bbox[0]
                    x = (self.display.width - text_width) // 2
                    draw.text((x, y), line, font=font, fill=255)
                    y += line_height
                break

        self.display.fill(0)
        self.display.image(image)
        self.display.show()


# Usage example:
oled = AutoSizeOLED()
oled.show_text("Hello!")  # Will show large

# sleep 2 seconds
time.sleep(2)

oled.show_text("This is an even much longer message")  # Will show smaller
