import cv2
import os
import time


def capture_image():
    os.makedirs('out', exist_ok=True)

    print("Initializing camera...")
    cap = cv2.VideoCapture(0)

    if not cap.isOpened():
        print("Initial open failed, trying with MJPG...")
        cap.release()
        cap = cv2.VideoCapture(0, cv2.CAP_V4L2)

        # Set MJPG format
        print("Setting camera parameters...")
        cap.set(cv2.CAP_PROP_FOURCC, cv2.VideoWriter_fourcc('M', 'J', 'P', 'G'))
        cap.set(cv2.CAP_PROP_FRAME_WIDTH, 1280)
        cap.set(cv2.CAP_PROP_FRAME_HEIGHT, 720)
        cap.set(cv2.CAP_PROP_FPS, 30)

    if not cap.isOpened():
        raise IOError("Could not open camera")

    print("Camera opened, waiting for initialization...")
    time.sleep(2)

    print("Capturing frame...")
    ret, frame = cap.read()
    if ret:
        cv2.imwrite('out/latest.jpg', frame)
        print("Image saved successfully")
    else:
        print("Failed to capture frame")

    cap.release()


if __name__ == "__main__":
    capture_image()
